﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SteakyPickup : MonoBehaviour
{
    [SerializeField] GameObject LevelOn;
    [SerializeField] AudioClip barkSFX;
    [SerializeField] int pointsForBonePickup = 100;

   private void OnTriggerEnter2D(Collider2D collision)
   {
       FindObjectOfType<GameSession>().AddToScore(pointsForBonePickup);
       AudioSource.PlayClipAtPoint(barkSFX, Camera.main.transform.position);
       LevelOn.SetActive(true);
       Destroy(gameObject);
   }
}
