﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GrindAI : MonoBehaviour
{

    public GameObject ThePlayer;
    public float TargetDistance;
    public float AllowedRange = 70;
    public GameObject TheEnemy;
    public float EnemySpeed;
    public int AttackTrigger;
    public RaycastHit Shot;



    void Update()
    {
        transform.LookAt(ThePlayer.transform);
        if (Physics.Raycast(transform.position, transform.TransformDirection(Vector3.forward), out Shot))
        {
            TargetDistance = Shot.distance;
            if (TargetDistance <= AllowedRange)
            {
                EnemySpeed = 0.03f;
                if (AttackTrigger == 0)
                {
                    TheEnemy.GetComponent<Animator>().Play("sneak");
                    transform.position = Vector3.MoveTowards(transform.position, ThePlayer.transform.position, EnemySpeed);
                }
            }
            else
            {
                EnemySpeed = 0;
                TheEnemy.GetComponent<Animator>().Play("GrindIdle");
            }
        }
        if (AttackTrigger == 1)
        {

            
            StartCoroutine(HP());


        }



    }

    void OnTriggerEnter(Collider other)
    {
        
        EnemySpeed = 0;
        TheEnemy.GetComponent<Animator>().Play("sneak");
        StartCoroutine(WT());

    }

    void OnTriggerExit(Collider other)
    {
        AttackTrigger = 0;
        EnemySpeed = 0;
    }

    IEnumerator HP()
    {
        
        yield return new WaitForSeconds(0.2f);
        AttackTrigger = 0;

    }

    IEnumerator WT()
    {
        yield return new WaitForSeconds(0.5f);
        AttackTrigger = 1;
        GlobalLives.LivesCount -= 1;
        yield return new WaitForSeconds(0.5f);
        EnemySpeed = 0;
        TheEnemy.GetComponent<Animator>().Play("sneak");
        AttackTrigger = 0;
    }

}