﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SkiControl : MonoBehaviour
{
    public GameObject Character;
    public bool isRunning;
    public float horizontalMove;
    public float verticalMove;

    public int stepNum;
    public bool isStepping = false;
    public AudioSource footStep1;
    public AudioSource footStep2;

    
    void Update()
    {


        if (Input.GetButton("Horizontal") || Input.GetButton("Vertical"))
        {
            isRunning = true;
            if (Input.GetButton("back"))
            {
                
                Character.GetComponent<Animation>().Play("SkiBackwards");

                horizontalMove = Input.GetAxis("Horizontal") * Time.deltaTime * 50;
                verticalMove = Input.GetAxis("Vertical") * -Time.deltaTime * -.5f;
               
  
            }

         
            else
            {
              

                    Character.GetComponent<Animation>().Play("SkiWalking");
                    horizontalMove = Input.GetAxis("Horizontal") * Time.deltaTime * 150;
                    verticalMove = Input.GetAxis("Vertical") * Time.deltaTime * 5;

              
                

            }

           




            if (isStepping == false)
            {
                StartCoroutine(PronRun());
            }
            transform.Rotate(0, horizontalMove, 0);
            transform.Translate(0, 0, verticalMove);

        }

        else
        {
            if (StartDagger.isFiring == false)
            {
            Character.GetComponent<Animation>().Play("SkiIdle");
            isRunning = false;
            }

           
        }

    



    }

    IEnumerator PronRun()
    {
        if (isRunning == true && isStepping == false)
        {
            isStepping = true;
            stepNum = Random.Range(1, 3);

            if (stepNum == 1)
            {
                footStep1.Play();
            }

            else
            {
                footStep2.Play();
            }
        }
        yield return new WaitForSeconds(0.3f);

        isStepping = false;

    }
}
