﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MonaDoorOpen : MonoBehaviour
{
    public GameObject MonaDoor;
    public GameObject MonaDoorSwitch;
    public AudioSource MonaDoorSwitchSound;

    void OnTriggerEnter(Collider other)
    {
        MonaDoorSwitchSound.Play();
        MonaDoor.GetComponent<Animator>().Play("MonaDoorAnim");
        MonaDoorSwitch.GetComponent<Animator>().Play("MonaDoorSwitchAnim");
        this.GetComponent<BoxCollider>().enabled = false;
        StartCoroutine(CloseDoor());

    }

    IEnumerator CloseDoor()
    {
        yield return new WaitForSeconds(5);
        MonaDoor.GetComponent<Animator>().Play("MonaDoorCloseAnim");
        this.GetComponent<BoxCollider>().enabled = true;
    }
}
