﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Interactable : MonoBehaviour
{
    [SerializeField] Sprite spriteCursor;
    [SerializeField] bool lookOnly;
    [SerializeField] Actions[] actions;
    [SerializeField] float distancePosition = 1f;

    public Sprite SpriteCursor { get { return spriteCursor; } }
    public bool LookOnly { get { return lookOnly; } }

    private void Reset()
    {
        gameObject.layer = LayerMask.NameToLayer("Interactable");
    }
    
    public Vector3 InteractPosition()
    {
        return transform.position + transform.forward * distancePosition;
    }

    public void Interact(SkiScript ski)
    {
        Debug.Log(gameObject.name + "Media to Media");
        StartCoroutine(WaitForSkiArriving(ski));
    }

    IEnumerator WaitForSkiArriving(SkiScript ski)
    {
        while(!ski.CheckIfArrived())
        {
            yield return null;
        }

        Debug.Log(gameObject.name + "Ski meets Torka");

        ski.SetDirection(transform.position);

        for (int i = 0; i < actions.Length; i++)
        {
            actions[i].Act();
        }

    
    }

}
