﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.AI;

public class SkiScript : MonoBehaviour
{
    [SerializeField] LayerMask interactLayer;
    private NavMeshAgent ski;
    private Camera mainCamera;

    private bool turning;
    private Quaternion targetRot;

    private SkiAnimation skiAnim = new SkiAnimation();

    // Start is called before the first frame update
    void Start()
    {
        mainCamera = Camera.main;
        ski = GetComponent<NavMeshAgent>();

        skiAnim.Init(GetComponentInChildren<Animator>());

        CameraManager.Instance.OnCameraSwitch += CameraSwitched;
    }

    private void OnDestroy()
    {
        CameraManager.Instance.OnCameraSwitch -= CameraSwitched;
    }

    // Update is called once per frame
    void Update()
  
    {
        if (Input.GetMouseButtonDown(0) && !Extensions.IsMouseOverUI())
        OnClick();

        if (turning && transform.rotation != targetRot)
        {
            transform.rotation = Quaternion.Slerp(transform.rotation, targetRot, 15f * Time.deltaTime);
        }

        if (!ski.isStopped && CheckIfArrived())
        ski.isStopped = true;

        skiAnim.UpdateAnimation(ski.velocity.sqrMagnitude);

    }

    void OnClick()
    {
        Debug.Log("Left Clicked!");

        RaycastHit hit;
        Ray camToScreen = mainCamera.ScreenPointToRay(Input.mousePosition);

        if (Physics.Raycast(camToScreen, out hit, Mathf.Infinity, interactLayer))
        {
            if (hit.collider != null)
            {
                Interactable interactable = hit.collider.GetComponent<Interactable>();

                if (interactable != null)
                {
                    if (!interactable.LookOnly)
                        MovePlayer(interactable.InteractPosition());

                    interactable.Interact(this);
                }
                else
                {
                    MovePlayer(hit.point);
                }
            }
        }
    }

    public bool CheckIfArrived()
    {
        return (!ski.pathPending && ski.remainingDistance <= ski.stoppingDistance);
    
    }

    void MovePlayer(Vector3 targetPosition)
    {
        turning = false;

        ski.isStopped = false;
        
        ski.SetDestination(targetPosition);

        DialogSystem.Instance.HideDialog();

   

    }

    public void SetDirection(Vector3 targetDirection)
    {
        turning = true;
        targetRot = Quaternion.LookRotation(targetDirection - transform.position);
    }

    void CameraSwitched(Camera cam)
    {
        mainCamera = cam;
    }
}
