﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ItemActions : Actions
{
    [SerializeField] ItemDatabase itemDatabase;
    [SerializeField] bool giveItem;
    [SerializeField] int amount;
    [SerializeField] Actions[] yesActions, noActions;

    public int itemId;

    [SerializeField] Item currentItem;

    public Item CurrentItem {get { return currentItem; } }

    public ItemDatabase ItemDatabase {get {return itemDatabase; } }

    public void ChangeItem(Item item)
    {
        if (CurrentItem.ItemId == item.ItemId)
        return;
      

      if (itemDatabase != null)
      currentItem = Extensions.CopyItem(item);
    }

    public override void Act()
    {
      if(giveItem)
      {

        int itemOwned = DataManager.Instance.Inventory.CheckAmount(CurrentItem);

        if(itemOwned > 0)
        {

         
          
          if(CurrentItem.AllowMultiple && amount <= itemOwned)
          {
            DataManager.Instance.Inventory.ModifyItemAmount(CurrentItem, amount);

            Extensions.RunActions(yesActions);
          }

          else if (!CurrentItem.AllowMultiple && itemOwned == 1)
          {
                    DataManager.Instance.Inventory.ModifyItemAmount(CurrentItem, -itemOwned);

                    Extensions.RunActions(yesActions);
          }

          else

          {
                    Extensions.RunActions(noActions);
          }
        }
      }

      else

      {
        if (CurrentItem.AllowMultiple)
        {
                DataManager.Instance.Inventory.ModifyItemAmount(CurrentItem, amount);
                Extensions.RunActions(yesActions);
        }
        else if (!CurrentItem.AllowMultiple)
        {
          if (DataManager.Instance.Inventory.CheckAmount(CurrentItem) == 1)
          {
            Extensions.RunActions(noActions);
          }
          else
          {
                    DataManager.Instance.Inventory.ModifyItemAmount(CurrentItem, 1);
                    Extensions.RunActions(yesActions);
          }
        }
      }
    }


}
