﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DataManager : MonoBehaviour
{
    public static DataManager Instance {get; private set; }
    public Inventory Inventory { get { return inventory; }}

    [SerializeField] Inventory inventory;

    public string PrevSceneName {get; private set; }


   private void Awake()
   {
       if (Instance == null)
       {
           Instance = this;
           DontDestroyOnLoad(gameObject);
       }
       else
       {
           Destroy(gameObject);
       }

   }

   public void SetPrevScene(string name)
   {
       PrevSceneName = name;
   }
}
