﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class ShipCollisionHandler : MonoBehaviour
{
    [SerializeField] float levelLoadDelay = 1f;
    [SerializeField] GameObject defeatFX;

    void OnTriggerEnter(Collider other)
    {
        StartDefeatSequence();
        defeatFX.SetActive(true);
        Invoke("ReloadScene", levelLoadDelay);
    }

    private void StartDefeatSequence()
    {
        SendMessage("OnPlayerDefeat");

    }

    private void ReloadScene()
    {
        SceneManager.LoadScene(0);
    }
}
