﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;


public class EnemyShips : MonoBehaviour
{
    [SerializeField] GameObject defeatFX;
    [SerializeField] Transform parent;

    [SerializeField] int scorePerHit = 10;
    [SerializeField] int hits = 10;

    ScoreBoard scoreBoard;

    // Start is called before the first frame update
    void Start()
    {
        AddBoxCollider();
        scoreBoard = FindObjectOfType<ScoreBoard>();
    }

    private void AddBoxCollider()
    {
        Collider boxCollider = gameObject.AddComponent<BoxCollider>();
        boxCollider.isTrigger = false;
    }

    void OnParticleCollision (GameObject other)
    {
        ProcessHit();
        if (hits <= 1)
        {
        DefeatEnemy();
        }
    }

    private void ProcessHit()
    {
        scoreBoard.ScoreHit(scorePerHit);
        hits = hits -1;
    }

    private void DefeatEnemy()
    {
        GameObject fx = Instantiate(defeatFX, transform.position, Quaternion.identity);
        fx.transform.parent = parent;
        Destroy(gameObject);
    }
}
