﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class RotateStars : MonoBehaviour
{

    public float rotateSpeed = 1.2f;

    void Awake() {
        {
            SetUpSingleton();
        }
    }

    void Update()
    {
        RenderSettings.skybox.SetFloat("_Rotation", Time.time * rotateSpeed);
    }

    private void SetUpSingleton()
    {
        if (FindObjectsOfType(GetType()).Length > 1)
        {
            Destroy(gameObject);

        }
            else
            {
                {
                    DontDestroyOnLoad(gameObject);
                }
            }
        }
    }

