﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SslugPlayer : MonoBehaviour
{
    public GameObject SslugCharacter;
    public bool isRunning;
    public float horizontalMove;
    public float verticalMove;
    public int stepNum;
    public bool isStepping = false;
    public AudioSource footstep1;
    public AudioSource footstep2;


    void Update()
    {
        if (Input.GetButton("Horizontal") || Input.GetButton("Vertical") && (!Input.GetMouseButton(1)))
        {
         SslugCharacter.GetComponent<Animator>().Play("SslugWalk");
         horizontalMove = Input.GetAxis("Horizontal") * Time.deltaTime * 125;
         verticalMove = Input.GetAxis("Vertical") * Time.deltaTime * 8;
         isRunning = true;
         if (isStepping == false)
         {
             StartCoroutine(RunSound());
         }
         transform.Rotate(0, horizontalMove, 0);
         transform.Translate(0, 0, verticalMove);
        }
        
        else
        {
            if (!Input.GetMouseButton(1))
            {
            SslugCharacter.GetComponent<Animator>().Play("SslugIdle");
            isRunning = false;
            }
        }

       
    }

    IEnumerator RunSound()
    {
        if (isRunning == true && isStepping == false)
        {
            isStepping = true;
            stepNum = Random.Range(1, 3);
            if (stepNum == 1)
            {
                footstep1.Play();
            }

            else
            
            {
                footstep2.Play();
            }

            yield return new WaitForSeconds(0.3f);
            
            isStepping = false;

        }
    }
}
